/* -*- C++ -*-
 *
 * <<< limited_counter.h >>>
 *
 * --- Limited counter class 'limited_counter'
 *     Copyright (C) 1998-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef LIMITED_COUNTER_H
#define LIMITED_COUNTER_H 1

#ifdef DEBUG
# include <cassert>
#endif // DEBUG
#include <iostream>

template <class T>
class limited_counter
{
public:
	typedef T value_type;
private:
	typedef limited_counter thisclass;
	static const int default_max_ = 1;
	value_type max_, value_;
public:
	explicit limited_counter(value_type a = default_max_)
		: max_(a), value_(0) {}
	value_type max(void) const { return max_; }
	value_type value(void) const { return value_; }
	bool is_max(void) const { return value_ == max_; }
	void output(ostream& os) const { os << value_; }
	const thisclass& increment(void)
		{ if (value_ < max_) value_++; return *this; }
	const thisclass& declement(void)
		{ if (value_ > 0) value_--; return *this; }
	void clear(void) { value_ = 0; }
	inline void set_max(value_type);
	operator value_type() const { return value_; }
	const thisclass& operator++(void)
		{ increment(); return *this; }
	thisclass operator++(int)
		{ thisclass tmp(*this); increment(); return tmp; }
	const thisclass& operator--(void)
		{ declement(); return *this; }
	thisclass operator--(int)
		{ thisclass tmp(*this); declement(); return tmp; }
	bool check_invariant(void) const
		{ return value_ >= 0 && value_ <= max_; }
};

template <class T>
inline void limited_counter<T>::set_max(limited_counter<T>::value_type a)
{
#ifdef DEBUG
	assert(a >= 0);
	max_ = a;
#else // DEBUG
	if (a >= 0) max_ = a;
#endif // DEBUG
}

template <class T>
inline ostream& operator<<(ostream& os, const limited_counter<T>& a)
{
	if (os) a.output(os);
#ifdef DEBUG
	os.flush();
#endif // DEBUG
	return os;
}

#endif /* LIMITED_COUNTER_H */
