/*
 * <<< bus_error_detector_test.cc >>>
 *
 * --- Test program for bus_error_detector class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include <iomanip>
#include "bus_port.h"
#include "bus_error_detector.h"

int main(void)
{
	typedef unsigned int word;
	bus_error_detector<word> mon;
	bus_port<word> bus_if;
	mon.port_ref().connect(bus_if);
	mon.set_timeout(100);
	bus_if.send_single_read_request(0x10);
	for (int i = 0; ; i++) {
		if (mon.is_bus_error()) break;
		cout << setw(4) << i << ' ' << bus_if << endl;
		mon.clock_in();
		mon.clock_out();
	}
	cout << mon << endl;
	return 0;
}
