/* -*- C++ -*-
 *
 * <<< gdb_stub_debugger.h >>>
 *
 * --- GDB stub interface debugger class 'gdb_stub_debugger'
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef GDB_STUB_DEBUGGER_H
#define GDB_STUB_DEBUGGER_H 1

#include <cctype>
#include <iostream>
#include <map>
#include <string>
#include "debugger.h"

template <class T>
class gdb_stub_debugger : public debugger<T>
{
public:
	typedef gdb_stub_debugger<T> thisclass;
	typedef debugger<T> inherited;
	typedef typename inherited::address_type address_type;
	typedef typename inherited::data_type data_type;
	typedef typename inherited::char_type char_type;
	typedef typename inherited::size_type size_type;
	typedef typename inherited::processor_type processor_type;
	typedef typename inherited::memory_map_type memory_map_type;
	typedef typename inherited::processing_element_type processing_element_type;
	typedef typename inherited::multiprocessor_type multiprocessor_type;
	static const size_t sizeof_data_type = inherited::sizeof_data_type;
private:
public:
	gdb_stub_debugger(void);
	gdb_stub_debugger(const gdb_stub_debugger<T>&);
	virtual ~gdb_stub_debugger();
	void set_standard_input_stream(istream&);
	void set_standard_output_stream(ostream&);
	void set_standard_error_stream(ostream&);
	void interactive_mode(void);
};

template <class T>
gdb_stub_debugger<T>::gdb_stub_debugger(void)
	: inherited(),
	  input_stream_(&cin),
	  output_stream_(&cout),
	  error_stream_(&cerr)
{}

template <class T>
gdb_stub_debugger<T>::gdb_stub_debugger(const gdb_stub_debugger<T>& a)
	: inherited(a),
	  input_stream_(a.input_stream_),
	  output_stream_(a.output_stream_),
	  error_stream_(a.error_stream_)
{}

template <class T>
gdb_stub_debugger<T>::~gdb_stub_debugger()
{}

template <class T>
void gdb_stub_debugger<T>::set_standard_input_stream(istream& a)
{
	input_stream_ = &a;
}

template <class T>
void gdb_stub_debugger<T>::set_standard_output_stream(ostream& a)
{
	output_stream_ = &a;
}

template <class T>
void gdb_stub_debugger<T>::set_standard_error_stream(ostream& a)
{
	error_stream_ = &a;
}

#endif /* GDB_STUB_DEBUGGER_H */
