/*
 * <<< isis.cc >>>
 *
 * --- ISIS utility functions class 'isis'
 *     Copyright (C) 1998-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#if HAVE_CONFIG_H
# include "config.h"
#endif // HAVE_CONFIG_H
extern "C" {
#if HAVE_FPSETMASK // to ignore floating point exception on FreeBSD
# if HAVE_FLOATINGPOINT_H
#  include <floatingpoint.h>
# endif // HAVE_FLOATINGPOINT_H
# if HAVE_IEEEFP_H
#  include <ieeefp.h>
# endif // HAVE_IEEEFP_H
#endif // HAVE_FPSETMASK
}
#include "isis.h"
#include "isis_config.h"

int isis::isis_object_counter = 0;

isis::isis(void)
{
	if (isis_object_counter++ == 0) isis_init_hook();
}

isis::~isis()
{
	if (--isis_object_counter == 0) isis_exit_hook();
}

void isis::isis_init_hook(void)
{
#if HAVE_FPSETMASK
	fpsetmask(0); // to ignore floating point exception on FreeBSD
#endif // HAVE_FPSETMASK
}

void isis::isis_exit_hook(void)
{
}

const char* isis::version_string(void)
{
#ifdef DEBUG
	static char str[] =
		"isis version " ISIS_VERSION " (" ISIS_REVISION ")"
		", with debug mode";
#else // DEBUG
	static char str[] =
		"isis version " ISIS_VERSION " (" ISIS_REVISION ")";
#endif // DEBUG
	return str;
}
