/* test bench */
`timescale 1ns/1ps
module convert;
parameter STEP = 10;
   reg [2:0] mode;
   reg [12:0] imm;
   reg [4:0] rd,rs1,rs2;
   reg [2:0] funct3;
   reg [6:0] opcode;
   reg [20:0] j_imm;
   reg [38:0] mem[0:4095];
    integer i;
    integer FP;

   initial begin
	  for(i=0;i<4096; i=i+1)
	  	mem[i] = 0;
	  $readmemb("tmp.dat",mem);
	  FP=$fopen("imem.dat");

   #STEP
   	  for(i=0;i<4096; i=i+1) begin
	  	{mode,imm,rs1,funct3,rd,opcode}= mem[i];
		j_imm = {imm,rs1,funct3};
		if(mode==3'b100) $fdisplay (FP,"%b_%b_%b_%b_%b__%b", imm[11:5],imm[4:0],rs1, funct3,rd,opcode);
		if(mode==3'b001) $fdisplay (FP,"%b_%b_%b_%b__%b", imm[11:0],rs1,funct3,rd,opcode);
		if(mode==3'b011) $fdisplay (FP,"%b_%b_%b_%b_%b__%b", {imm[12],imm[10:5]},rd,rs1,funct3,{imm[4:1],imm[11]},opcode);
		if(mode==3'b010) $fdisplay (FP,"%b_%b_%b_%b_%b__%b", imm[11:5],rd,rs1,funct3,imm[4:0],opcode);
		if(mode==3'b110) $fdisplay (FP,"%b_%b__%b", j_imm[19:0],rd,opcode);
		if(mode==3'b111) $fdisplay (FP,"%b_%b__%b", {j_imm[20],j_imm[10:1],j_imm[11],j_imm[19:12]},rd,opcode);
	  end  	
     $finish;
   end
endmodule
