/* test bench */
`timescale 1ns/1ps
`include "def.h"
`define RPLS_BIT 2'b01
`define CRDY_BIT 2'b10
`define WBAK_BIT 2'b11
`define IDLE_BIT 2'b00

module test;
parameter STEP = 10;
   reg clk, rst_n;
   wire [`DATA_W-1:0] odata, mdata, wdata ;
   wire [`DATA_W-1:0] daddr, iaddr;
   wire we, req, mem_req, rdy, mem_rdy;
   reg [`DATA_W-1:0] imem [0:`DEPTH-1];
   wire [9:0] maddr;
   wire mem_we;
   reg [12:0] count;

   always #(STEP/2) begin
            clk <= ~clk;
   end

   poco poco_1(.clk(clk), .rst_n(rst_n), .idatain(imem[iaddr]),
               .ddatain(odata), .iaddr(iaddr), .daddr(daddr),
               .ddataout(wdata), .we(we), .req(req), .rdy(rdy) );
   cache cache_1(.clk(clk), .rst_n(rst_n), .paddr(daddr[9:0]), .maddr(maddr),
		.pdata(wdata), .we(we), .mem_we(mem_we),
		.mdata(mdata), .odata(odata), .mem_rdy(mem_rdy),
		.rdy(rdy), .mem_req(mem_req), .req(req));
   mmem mmem_1(.clk(clk), .addr(maddr),	.datain(odata),
		.dataout(mdata), .rdy(mem_rdy), .req(mem_req),
		.we(mem_we));
	

   initial begin
      $dumpfile("poco.vcd");
      $dumpvars(0,test);
      $readmemb("imem.dat", imem);
      $readmemb("tmem.dat", cache_1.tagm);
      $readmemh("dmem.dat", mmem_1.mem);
      clk <= `DISABLE;
      rst_n <= `ENABLE_N;
	  count <= 0; 
   #(STEP*1/4)
   #STEP
      rst_n <= `DISABLE_N;
   #(STEP*1000)            
   $finish;
   end

   always @(negedge clk) begin
   	count<= count+1;
      $display("count:%d pc:%h idatain:%b ",count, poco_1.pc, poco_1.idatain);
      $display("reg:%h %h %h %h %h %h %h %h", 
	poco_1.rfile_1.r0, poco_1.rfile_1.r1, poco_1.rfile_1.r2,
	poco_1.rfile_1.r3, poco_1.rfile_1.r4, poco_1.rfile_1.r5,
	poco_1.rfile_1.r6, poco_1.rfile_1.r7);
      $display("cmem0-7:%h %h %h %h %h %h %h %h", 
	cache_1.cmem[0], cache_1.cmem[1], cache_1.cmem[2], 
	cache_1.cmem[3], cache_1.cmem[4], cache_1.cmem[5], 
	cache_1.cmem[6], cache_1.cmem[7]);
	if(req) begin
		if(cache_1.hit& ~we) $display("Dmem read %h: cache hit",daddr);
		else if(cache_1.hit&we) $display("Dmem write %h: cache hit",daddr);
		else if(cache_1.stat[`WBAK_BIT]&!cache_1.mem_rdy) $display("Memory wait for Write back %h",maddr); 
		else if(cache_1.stat[`WBAK_BIT]&cache_1.mem_rdy) $display("Write back %h",maddr); 
		else if(cache_1.stat[`RPLS_BIT]&!cache_1.mem_rdy) $display("Memory wait for replace %h",maddr); 
		else if(cache_1.stat[`RPLS_BIT]&cache_1.mem_rdy) $display("Replace %h",maddr); 
		else if(cache_1.stat[`IDLE_BIT]&!cache_1.hit) $display("Cache Miss %h",maddr); 
	end
	if(cache_1.stat[`CRDY_BIT]) $display("Cache fill");
   end
endmodule
