#!/usr/bin/env ruby

class Poco < Arch
  def initialize
    super('poco')
    @pc_incr = 1
    @var = {
      # VAR_NAME => [BIT_NUM, SIGN, ADDR_ATTR]
      #   SIGN     : 'signed' or 'unsigned' or 'signed/label' or 'unsigned/label'
      #   ADDR_ATTR: nil or 'relative' or 'absolute'
      'd'   => [3,  'unsigned',       nil       ],
      's'   => [3,  'unsigned',       nil       ],
      'a'   => [3,  'unsigned',       nil       ],
      'i'   => [8,  'signed',         nil       ],
      'u'   => [8,  'unsigned',       nil       ],
      'il'  => [8,  'signed/label',   'relative'],
      'ul'  => [8,  'unsigned/label', 'absolute'],
      'Xla' => [11, 'signed/label',   'absolute'],
      'Xlr' => [11, 'signed/label',   'relative']
    }
    @op = {
      # OPCODE => [OPERAND(s), BIN]
      #   ${VARIABLE} must be declared in @var
      'NOP'   => ['',                            '00000_xxx_xxx_00000'  ],
      'MV'    => ['r${d}\s*,\s*r${s}',           '00000_${d}_${s}_00001'],
      'AND'   => ['r${d}\s*,\s*r${s}',           '00000_${d}_${s}_00010'],
      'OR'    => ['r${d}\s*,\s*r${s}',           '00000_${d}_${s}_00011'],
      'SL'    => ['r${d}',                       '00000_${d}_xxx_00100' ],
      'SR'    => ['r${d}',                       '00000_${d}_xxx_00101' ],
      'ADD'   => ['r${d}\s*,\s*r${s}',           '00000_${d}_${s}_00110'],
      'SUB'   => ['r${d}\s*,\s*r${s}',           '00000_${d}_${s}_00111'],
      'ST'    => ['r${s}\s*,\s*\(\s*r${a}\s*\)', '00000_${s}_${a}_01000'],
      'LD'    => ['r${d}\s*,\s*\(\s*r${a}\s*\)', '00000_${d}_${a}_01001'],
      'LDI'   => ['r${d}\s*,\s*#${i}',           '01000_${d}_${i}'      ],
      'LDIU'  => ['r${d}\s*,\s*#${u}',           '01001_${d}_${u}'      ],
      'ADDI'  => ['r${d}\s*,\s*#${i}',           '01100_${d}_${i}'      ],
      'ADDIU' => ['r${d}\s*,\s*#${u}',           '01101_${d}_${u}'      ],
      'LDHI'  => ['r${d}\s*,\s*#${i}',           '01010_${d}_${i}'      ],
      'BEZ'   => ['r${d}\s*,\s*${il}',           '10000_${d}_${il}'     ],
      'BNZ'   => ['r${d}\s*,\s*${il}',           '10001_${d}_${il}'     ],
      'BPL'   => ['r${d}\s*,\s*${il}',           '10010_${d}_${il}'     ],
      'BMI'   => ['r${d}\s*,\s*${il}',           '10011_${d}_${il}'     ],
      'JMP'   => ['${Xlr}',                      '10100_${Xlr}'         ],
      'JAL'   => ['${Xla}',                      '10101_${Xla}'         ],
      'JR'    => ['r${d}',                       '00000_${d}_xxx_01010' ],
      'JALR'  => ['r${d}',                       '00000_${d}_xxx_01011' ]
    }
  end
  
  
  def absolute_branch_address(cur_pc, dst_pc)
    return dst_pc
  end
  
  
  def relative_branch_address(cur_pc, dst_pc)
    return dst_pc - cur_pc - @pc_incr
  end
end


$arch = Poco.new
