`include "mydefinition.h"

`timescale 1ns/1ps

module lcdUser_test;
   reg clk, rst_;
   wire [`LCDCOMMAND] command;
   wire 	      commandEnable;

   parameter 	      STEP = 10;
   
   initial begin
      $shm_open();
      $shm_probe("AC");
   end

   always #(STEP/2) clk = ~clk;

   initial begin
      clk = 1;
      rst_ = 1;
      #(STEP*50);
      rst_ = 0;
      #(STEP*50);
      rst_ = 1;
      #(STEP*50);
      $finish;
   end
   
   lcdUser LU( .clk( clk),
	       .rst_( rst_),
	       .command( command),
	       .commandEnable( commandEnable));
endmodule // lcdUser_test
